#############################################################################
# Configure the tools appropriately.                                        #
#############################################################################
!if $d(DLL)

# This is the major file version # of the RTL DLL.
DLLMAJOR        = 7

# The version number of the product in which this C++ RTL appears
DLLPRODVERSTR   = 4.0

# BETA is defined only prior to RTM and indicates the current milestone.
#BETA            =pre-alpha

# A proper copyright string
DLLCOPYRIGHTSTR = Copyright  Borland Corporation 1994,2005

# The name of the product in which this C++ RTL appears
DLLPRODNAMESTR  = Borland Developer Studio

# The DLLs numeric file version value.
DLLNUMERICFILEVERSION = 0x0$(DLLMAJOR)000000

# DLLVER is the file version number of the RTL *.DLL files: the xx (c?32xx*.dll)
# DLLVERSTR is a string representation of the same number for VERSION.RC
  DLLVER        = $(DLLMAJOR)0
  DLLVERSTR     = $(DLLMAJOR).0
!if $d(MT)
!if $d(MAGIC)
  DLLDESCSTR    = Borland C++ Multi-thread RTL (WIN/VCL MT)
!endif # MAGIC
!else
  DLLDESCSTR    = Borland C++ Single-thread RTL (WIN ST)
!endif # MT

# -b:0x32X00000 for base address - X should be only the major version num.
#               ie: 4 for 40 & 45, 5 for 50, 6 for 60, 7 for 70...
LINKER_DLL_BASE_SWITCH=-b:0x32$(DLLMAJOR)00000

!endif

!if $d(MAGIC) && $d(DLL)
!  if $d(RTLSOURCE)
     EXTLIB=$(BCB)\lib\release\vcl.lib  \
            $(BCB)\lib\release\vcle.lib \
            $(BCB)\lib\release\rtl.lib
!  else
     EXTLIB=$(EXTDIR)\vcl.lib  \
            $(EXTDIR)\vcle.lib \
            $(EXTLIB)\rtl.lib
!  endif
!endif

!if $d(RTLSOURCE)
AFLAGS   = /kh30000 -t -m -D__WIN32__ -I$(INCLBASE)\rtlinc -I$(BCINCL:;= -I)
!else
AFLAGS   = /kh30000 -t -m -D__WIN32__ -I$(INCLBASE)\rtlinc -I$(INCLBASE)
!endif
!if $d(TASM_CASE_SENSITIVE)
AFLAGS   = -ml $(AFLAGS)
!else
AFLAGS   = -mx $(AFLAGS)
!endif

# If generating ELF use NASM
!if $d(ELF)
ASM	 = nasmw
AFLAGS   = -t -felf
!else
ASM      = tasm32
!endif

BRCC     = brcc32
!if $d(MT)
  BRCC   = $(BRCC) -d__MT__
!endif
!if $d(MAGIC)
  BRCC   = $(BRCC) -dMAGIC
!endif


!if $d(ELF)
CC       = bccx $(CFLAGS) $(XTRAFLAGS) $(CCXTRAFLAGS)
CPP      = bccx $(CFLAGS) $(XTRAFLAGS) $(CPPXTRAFLAGS)
CFLAGS   = -c -n$(OBJDIR) -I$(INCLUDES:;= -I)
!else
CC       = bcc32 +$(OBJDIR)\$(CFG) $(XTRAFLAGS) $(CCXTRAFLAGS)
CPP      = cpp32 +$(OBJDIR)\$(CFG) $(XTRAFLAGS) $(CPPXTRAFLAGS)
CFLAGS   = -c -X -n$(OBJDIR) -I$(INCLUDES:;= -I) -ff- -j3 -jb -w -w-sig -V? -Q
!endif

CFLAGS	 = $(CFLAGS) -D__RTL_BUILD__ -DNO_STRICT -D__USELOCALES__

!if !$d(MINIRTL) && !$d(DINKUMWARE)
CFLAGS   = $(CFLAGS) -D_USE_OLDER_RW_STL
!endif

!if $d(DINKUMWARE)
CFLAGS = $(CFLAGS) -w-8076 -D_DINKUMWARE

!if !$d(MT)
    CFLAGS = $(CFLAGS) -D_NO_MT
!endif

!if $d(DLL)
    CFLAGS = $(CFLAGS) -D__FORCE_INSTANCE
!endif

!endif

!if $d(MINIRTL)
CFLAGS   = $(CFLAGS) -DMINIRTL
!endif

!if $d(MINIRTL_EDG)
CFLAGS   = $(CFLAGS) -DMINIRTL_EDG -DELF -DEDG
!endif

!if $d(CREATE_ALLSTL)
CFLAGS   = $(CFLAGS) -Jgi -w- -D__CREATE_ALLSTL__
!endif
IMPLIB   = implib -i -c -f
!if $d(RTLSOURCE)
INCLUDES = $(BCINCL);$(INCLBASE)\rtlinc
!else
INCLUDES = $(INCLBASE);$(INCLBASE)\windows;$(INCLBASE)\rtlinc
!endif
!if $d(DINKUMWARE)
INCLUDES = $(INCLUDES);$(INCLBASE)\dinkumware
!endif
!if $d(DLL)
LINK     = ilink32
LINKEROPTS=$(LINKEROPTS) -s -c -Tpd -Gn -Gm -M $(LINKER_DLL_BASE_SWITCH)
LINKEROPTS=$(LINKEROPTS) -D"$(DLLDESCSTR)"
!if $d(RTLSOURCE)
LINKEROPTS=$(LINKEROPTS) -L$(BCB)\lib
!endif
!endif

!if $d(MAGIC)
#
# The RTLDLL now has the prefix CC32 always.  The CC32xxMT.DLL supports
# both the standard Win32 RTL (the old CW32...) and the VCL compatible RTL
# (the old CP32...). The import libraries will still have the same names:
# cw32i, cw32mti, cp32mti
#
LIBNAME      = cp32
LIBNAME_W    = cw32
DLLBASENAME  = cc32
!else
!if $d(MINIRTL_EDG)
LIBNAME      = cw32edgmini
!elif $d(MINIRTL)
LIBNAME      = cw32mini
!else
LIBNAME      = cw32
DLLBASENAME  = cc32
!endif
!endif

!if $(EDG)
OBJDIR = $(OBJBASE)\obj$(MAGICSUFFIX)$(MTSUFFIX)$(DLLSUFFIX)
!else
OBJDIR = $(OBJBASE)\obj$(MAGICSUFFIX)$(MTSUFFIX)$(DLLSUFFIX)
!endif
PUBTOOL = pubdup.exe
PUBNAME = names32.pub

!if $d(DEBUG)
    TLIB = tlib /C /P512
    TLIB_NO_PURGE = tlib /C /P512
!if !$d(ELF)
    CFLAGS = $(CFLAGS) -D_RWDEBUG=1 -x -xp
!else
    CFLAGS = $(CFLAGS) -v
!endif
!else
    TLIB = tlib /C /0 /P512
    TLIB_NO_PURGE = tlib /C /P512
    CFLAGS = $(CFLAGS) -O2
!endif

!if $d(MAGIC)
    CFLAGS = $(CFLAGS) -DMAGIC
    AFLAGS = $(AFLAGS) -DMAGIC
    MAGICSUFFIX = mg
!endif

# Select the PRONTODEBUGGER exception hooks, see include\rtlinc\xxdbg.h
CFLAGS = $(CFLAGS) -DPRONTODEBUGGER

!if $d(MT)
    AFLAGS = $(AFLAGS) -D_MT
!if !$d(ELF)
    CFLAGS = $(CFLAGS) -WM
!endif
    MTSUFFIX = mt
!else
!if !$d(ELF)
    CFLAGS = $(CFLAGS) -WM-
!endif
!endif

!if $d(BETA)
    CFLAGS = $(CFLAGS) "-D__RTL_BETA=$(BETA)"
!endif

!if $d(MBCS)
    CFLAGS = $(CFLAGS) -D_MBCS -D_MBC_USE_MACROS
    AFLAGS = $(AFLAGS) -D_MBCS -D_MBC_USE_MACROS
!endif

!if $d(DLL)
    AFLAGS = $(AFLAGS) -D_BUILDRTLDLL
    CFLAGS = $(CFLAGS) -D_BUILDRTLDLL -WD -D_RWSTDBUILDDLL -D_RWSTDDLL \
             "-D__RTLDLLVERSTR=\"$(DLLVER)\""

    BRCC = $(BRCC) "-D__RTLDLLVERSTR=\"$(DLLVERSTR)\0\""
    BRCC = $(BRCC) "-D__RTLDLLNUMERICFILEVER=$(DLLNUMERICFILEVERSION)"
    BRCC = $(BRCC) "-D__RTLDLLPRODNAMESTR=\"$(DLLPRODNAMESTR)\0\""
    BRCC = $(BRCC) "-D__RTLDLLPRODVERSTR=\"$(DLLPRODVERSTR)\0\""
    BRCC = $(BRCC) "-D__RTLDLLDESCSTR=\"$(DLLDESCSTR)\0\""
    BRCC = $(BRCC) "-D__RTLDLLCOPYRIGHTSTR=\"$(DLLCOPYRIGHTSTR)\0\""
!if $d(BETA)
    BRCC = $(BRCC) "-D__RTLDLLBETASTR=\"[pre-release version: $(BETA)]\0\""
!endif
    DLLC0 = c0d32
    DLLNAME = $(DLLBASENAME)$(DLLVER)$(MTSUFFIX)
    DLLSUFFIX = x
    IMPLIBNAME = $(LIBNAME)$(MTSUFFIX)i
    IMPORT = import32
!if $d(MAGIC)
    IMPORT = $(IMPORT)
    IMPLIBNAME_W = $(LIBNAME_W)$(MTSUFFIX)i
# Don't force in the VCL memory manager any more
#$(EXTDIR)\memmgr.lib
!endif
!else
!if !$d(ELF)
    CFLAGS = $(CFLAGS) -W
!endif
!endif

#############################################################################
# $(CFG) is created only once for each build.  In order to modify compiler  #
# options on a source directory basis, CC should be modified instead of     #
# CFLAGS.                                                                   #
#############################################################################
!if $d(PCH)
    CC = $(CC) -H -Hc -Hs- -H=$(OBJBASE).csm
!endif

#############################################################################
# The source directories.                                                   #
#############################################################################

#----------------------------------------------------------------------------
# Note: The following dirs must be built in this order for the RTL to work
#----------------------------------------------------------------------------

!if $d(INTERNAL_BUILD) && !$d(DINKUMWARE)
SRCDIRS =                                     \
          $(SRCBASE)\memory                   \
          $(SRCBASE)\vcl                      \
          $(SRCBASE)\stl\rw201\predecl        \
          $(SRCBASE)\stl\rw201\allstl         \
          $(SRCBASE)\stl\rw201                \
          $(SRCBASE)\conio                    \
          $(SRCBASE)\cstrings                 \
          $(SRCBASE)\except                   \
          $(SRCBASE)\io                       \
          $(SRCBASE)\locale                   \
          $(SRCBASE)\math                     \
          $(SRCBASE)\mbcs                     \
          $(SRCBASE)\misc                     \
          $(SRCBASE)\process                  \
          $(SRCBASE)\startup                  \
          $(SRCBASE)\threads                  \
          $(SRCBASE)\time                     \
          $(SRCBASE)\pcre
!elif $d(INTERNAL_BUILD) && $d(DINKUMWARE)
SRCDIRS =                                     \
          $(DINKSRCBASE)                      \
          $(SRCBASE)\memory                   \
          $(SRCBASE)\vcl                      \
          $(SRCBASE)\conio                    \
          $(SRCBASE)\cstrings                 \
          $(SRCBASE)\except                   \
          $(SRCBASE)\io                       \
          $(SRCBASE)\locale                   \
          $(SRCBASE)\math                     \
          $(SRCBASE)\mbcs                     \
          $(SRCBASE)\misc                     \
          $(SRCBASE)\process                  \
          $(SRCBASE)\startup                  \
          $(SRCBASE)\threads                  \
          $(SRCBASE)\time                     \
          $(SRCBASE)\pcre

!elif $d(MINIRTL_EDG) # remove except
SRCDIRS =                                     \
	  $(SRCBASE)\conio		      \
	  $(SRCBASE)\cstrings		      \
          $(SRCBASE)\io    		      \
          $(SRCBASE)\math    		      \
          $(SRCBASE)\memory                   \
          $(SRCBASE)\misc                     \
	  $(SRCBASE)\process		      \
	  $(SRCBASE)\startup		      \
	  $(SRCBASE)\threads		      \
	  $(SRCBASE)\time
!elif $d(MINIRTL)
SRCDIRS =                                     \
	  $(SRCBASE)\cstrings		      \
	  $(SRCBASE)\except		      \
          $(SRCBASE)\io    		      \
          $(SRCBASE)\math                     \
          $(SRCBASE)\memory                   \
          $(SRCBASE)\misc                     \
	  $(SRCBASE)\process		      \
	  $(SRCBASE)\startup		      \
	  $(SRCBASE)\threads
!elif $d(DINKUMWARE)
SRCDIRS =                                     \
          $(DINKSRCBASE)                      \
          $(SRCBASE)\memory                   \
          $(SRCBASE)\vcl                      \
          $(SRCBASE)\conio                    \
          $(SRCBASE)\cstrings                 \
          $(SRCBASE)\except                   \
          $(SRCBASE)\io                       \
          $(SRCBASE)\locale                   \
          $(SRCBASE)\math                     \
          $(SRCBASE)\mbcs                     \
          $(SRCBASE)\misc                     \
          $(SRCBASE)\process                  \
          $(SRCBASE)\startup                  \
          $(SRCBASE)\threads                  \
          $(SRCBASE)\time                     \
          $(SRCBASE)\pcre

!else
SRCDIRS =                                     \
          $(SRCBASE)\memory                   \
          $(SRCBASE)\vcl                      \
          $(SRCBASE)\stl\predecl              \
          $(SRCBASE)\stl\allstl               \
          $(SRCBASE)\stl                      \
          $(SRCBASE)\conio                    \
          $(SRCBASE)\cstrings                 \
          $(SRCBASE)\except                   \
          $(SRCBASE)\io                       \
          $(SRCBASE)\locale                   \
          $(SRCBASE)\math                     \
          $(SRCBASE)\mbcs                     \
          $(SRCBASE)\misc                     \
          $(SRCBASE)\process                  \
          $(SRCBASE)\startup                  \
          $(SRCBASE)\threads                  \
          $(SRCBASE)\time                     \
          $(SRCBASE)\pcre
!endif

#!if !$d(DLL) && (!$d(MT) || $d(MAGIC))
!if !$d(MINIRTL)
    SRCDIRS = $(SRCDIRS)                \
              $(SRCBASE)\defs
!endif
#!endif
